﻿var multimediaLibrary = {
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        multimediaLibrary.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-multimediaTable").a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetMultimediaFiles", "MultimediaGallery", "Library"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id", "Type": "numeric", "Width": "50px" },
                { "Name": "Preview", "Title": resources.Preview, "Data": "Url", "Class": "item-url v-itemUrl", "Sortable": false, "AdvancedFilter": false },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "MediaTypeId", "Title": resources.Type, "Data": "MediaType", "Class": "media-type v-mediaType", "Type": "enum", "EnumType": "MediaType", "Width": "80px" },
                { "Name": "Category", "Title": resources.Category, "Data": "Category", "Class": "category" },
                { "Name": "Description", "Title": resources.Description, "Data": "Description" },
                { "Name": "Url", "Title": resources.Url, "Data": "Url", "Class": "v-itemUrlDisplay" },
                { "Name": "CreationDate", "Title": resources.CreatedOn, "Data": "CreationDate", "Type": "datetime" }
            ],
            defaultSorting: { Column: "Name", Ascending: true },
            stateKey: "MultimediaLibrary",
            toolBarItems: multimediaLibrary.getToolBarItems(),
            contextMenuItems: multimediaLibrary.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "changeCategory":
                        multimediaLibrary.changeItemsCategory(ids);
                        break;
                    case "delete":
                        multimediaLibrary.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        multimediaLibrary.editItem(row);
                        break;
                    case "delete":
                        multimediaLibrary.deleteItems(row.Id);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": types.Image, "AjaxParams": { "type": 1 } },
                    { "Label": types.Video, "AjaxParams": { "type": 2 } },
                    { "Label": types.Audio, "AjaxParams": { "type": 3 } },
                    { "Label": types.HTML, "AjaxParams": { "type": 4 } }
                ]
            },
            localizableTexts: { "All": resources.AllMultimediaGallery, "Search": resources.SearchMultimediaFiles },
            rowBeforeCreated: function (event, data) {
                var row = data.row;
                var data = data.data;
                var url = data['Url'];
                var name = data['Name'];
                var mediaType = data['MediaType'];
                var questionnaireId = data['QuestionnaireId'];
                var urlPrefix = "";
                var imgTag;

                if (!multimediaLibrary.isExternalUrl(url)) {
                    if (questionnaireId != "0") {
                        urlPrefix = webPath + questionnaireId + "/";
                    } else {
                        urlPrefix = webPath;
                    }
                }

                $("td.v-itemUrlDisplay", row).first().html(urlPrefix + url);

                switch (mediaType) {
                    case "Image":
                        imgTag = '<a href="' + urlPrefix + url + '" class="v-image-preview" target="_blank"><img src="' + urlPrefix + url + '" alt="' + name + '" /></a>';
                        $("td.v-itemUrl", row).first().html(imgTag);

                        break;
                    default:
                        imgTag = '<a target="_blank" href="' + urlPrefix + url + '" class="icon ' + mediaType.toLowerCase() + '-file-icon" title="' + mediaType + '"><span>' + mediaType + '</span></span>';
                        $("td.v-itemUrl", row).first().html(imgTag);

                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addFile", function () {
            modalDialog.showWindow(a4.getAction("ItemEditor", "MultimediaGallery", "Library"), 500, 950);
        });

        $(document).on("click", ".h-manage-category", function () {
            modalDialog.showWindow(a4.getAction("CategoriesEditor", "MultimediaGallery", "Library"), 500, 950, { afterClose: function () { multimediaLibrary.refreshDataTable(); } });
        });

        $(".v-image-preview").fancybox({
            'hideOnContentClick': true
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteMultimediaResources, function () {
            a4.callServerMethod(a4.getAction("DeleteItems", "MultimediaGallery", "Library"), { fileIds: items },
                function (result) {
                    multimediaLibrary.refreshDataTable();
                });
        }, 250, 500, true, { "count": itemsCount });
    },
    changeItemsCategory: function (items) {
        multimediaLibrary.changeCategoryItems = items;
        modalDialog.showWindow(a4.getAction("ItemsCategoryEditor", "MultimediaGallery", "Library", { fileId: items[0] }), 250, 500, { afterClose: function () { multimediaLibrary.changeItemsCategoryOnClose(); } });
    },
    changeItemsCategoryOnSave: function (categoryId) {
        a4.callServerMethod(a4.getAction("UpdateItemsCategory", "MultimediaGallery", "Library"), { itemIds: multimediaLibrary.changeCategoryItems, categoryId: categoryId },
        function (result) {
            multimediaLibrary.changeCategoryItems = null;
            multimediaLibrary.refreshDataTable();
            modalDialog.close();
        },
        function (error) {
            multimediaLibrary.changeCategoryItems = null;
            modalDialog.close();
            var message = eval("(" + error.responseText + ")").Message;
            a4.showErrorMessage(message);
        });
    },
    changeItemsCategoryOnClose: function (categoryId) {
        multimediaLibrary.changeCategoryItems = null;
    },
    editItem: function (item) {
        modalDialog.showWindow(a4.getAction("ItemEditor", "MultimediaGallery", "Library", { fileId: item.Id }), 500, 950);
    },
    isExternalUrl: function (fileUrl) {
        if (fileUrl) {
            return fileUrl.toLowerCase().substring(0, 7) == "http://" || fileUrl.toLowerCase().substring(0, 8) == "https://";
        }
        else {
            return false;
        }
    },
    getContextMenuItems: function () {
        var items = Array();

        if (canModify) {
            items.push({ "Action": "edit", "Label": resources.Edit });
            items.push({ "Action": "delete", "Label": resources.Delete });
        }

        return items;
    },
    getToolBarItems: function () {
        if (canModify) {
            return [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "changeCategory", "Label": resources.ChangeCategory }
            ]
        }
        else return [];
    }
}

$(document).ready(function () {
    multimediaLibrary.initializeDataTable();
    multimediaLibrary.bindEvents();
});